<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit; // Exit early for OPTIONS preflight request
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once("config.php");

$input = json_decode(file_get_contents('php://input'), true);

//Stripe payment intent
$address = $input['address'];
$countryName = $address['country'];
$zip = $address['postal_code'];
$countryISO = countryNameToISO($countryName);
$address['country'] = $countryISO;
$amount = $input['amount'];
$currency = $input['currency'];
$taxReturn =  json_decode(calculateTax($amount, $countryName, $zip, true), true);
if (isset($taxReturn['tax_percent'])) {
  $taxPercent = floatval($taxReturn['tax_percent']);
  $taxVal = floatval($amount * ($taxPercent / 100));
} else {
  // Handle error
  $error = $taxReturn['error'] ?? 'Unknown error calculating tax';
  echo json_encode(['error' => $error]);
  exit;
}

try {
  $intent = \Stripe\PaymentIntent::create([
    'amount' => round(($amount + $taxVal) * 100),
    'currency' => $currency,
    'description' => 'Subtotal: ' . $amount . ', Tax: ' . $taxVal,
    'shipping' => [
      'name' => $input['company_name'],
      'address' => $address
    ]
  ]);
  echo json_encode(['client_secret' => $intent->client_secret]);
} catch (Exception $e) {
  error_log("Stripe Error: " . $e->getMessage());
  http_response_code(500);
  echo json_encode(['error' => 'Stripe Error: ' . $e->getMessage()]);
  exit;
}

?>
